/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.service;

import itx.erp.sales.conf.SalesSettings;
import itx.erp.sales.model.Article;
import itx.erp.sales.model.ArticleGroup;
import itx.erp.sales.model.ArticleSlotplanPrice;
import itx.erp.sales.model.Vat;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import jtbcore.db.common.QueryBuilder;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.InvalidStateException;
import jtbcore.exception.JTBException;
import jtbcore.model.BaseStringMap;
import jtbcore.service.ServiceBase;
import jtbcore.util.MapUtil;

public class ArticleService
extends ServiceBase {
    protected SalesSettings salesSettings;

    public SalesSettings getSalesSettings() {
        return this.salesSettings;
    }

    public void setSalesSettings(SalesSettings salesSettings) {
        this.salesSettings = salesSettings;
    }

    public QueryResult<Article> searchArticle(Map<String, Object> opts) throws SQLException, JTBException {
        QueryBuilder b = new QueryBuilder(this.connection);
        b.setTable("sales__article");
        b.addSelectField("sales__article", "article_id");
        b.addSelectField("sales__article", "article_code");
        b.addSelectField("sales__article", "short_description");
        b.addSelectField("sales__article", "rentable");
        b.addSelectField("sales__article", "pricing_method");
        b.addSelectField("sales__article", "overbookable");
        b.addSelectField("sales__article", "price");
        b.addSelectField("sales__article", "active");
        b.addSelectField("sales__article", "edited");
        if (MapUtil.hasProperty(opts, "q")) {
            String q = opts.get("q").toString().trim();
            b.addWhere(" short_description like ? or article_code like ? or article_code like ? ", "%" + q + "%", q + "%", "%" + q);
        }
        if (MapUtil.boolValue(opts, "rentable")) {
            b.addWhere(" rentable = true ", new Object[0]);
        }
        b.setRawOrderBy("lower(short_description)");
        ResultSet rs = b.queryResultSet();
        QueryResult<Article> qr = new QueryResult<Article>();
        if (opts.containsKey("start")) {
            qr.setStart((Integer)opts.get("start"));
        }
        if (opts.containsKey("pageSize")) {
            qr.setPageSize((Integer)opts.get("pageSize"));
        }
        qr.fill(Article.class, rs);
        rs.close();
        List arts = qr.getObjects();
        int x = 0;
        while (x < arts.size()) {
            Article art = this.readArticle(((Article)arts.get(x)).getArticleId());
            arts.set(x, art);
            ++x;
        }
        return qr;
    }

    public Article readArticle(Integer articleId) throws SQLException, JTBException {
        Article a = (Article)this.queryToObject(Article.class, "select * from sales__article where article_id = ?", articleId);
        if (a.getVatId() != null) {
            Vat v = this.readVat(a.getVatId());
            a.setVat(v);
        }
        List<BaseStringMap> bsms = this.connection.queryBsmList("select * from sales__article_article_group where article_id = ?", a.getArticleId());
        for (BaseStringMap bsm : bsms) {
            a.getArticleGroupIds().add(bsm.getPropertyInt("article_group_id"));
            if (!bsm.getPropertyBool("main_group").booleanValue()) continue;
            a.setMainArticleGroupId(bsm.getPropertyInt("article_group_id"));
        }
        if (a.getSlotplanId() != null) {
            List<BaseStringMap> pts = this.connection.queryBsmList("select asp.*, spt.name slotplan_pricetype_name from sales__slotplan_pricetype spt left join sales__article_slotplan_price asp on ( asp.slotplan_pricetype_id = spt.slotplan_pricetype_id and article_id = ? )  where spt.slotplan_pricetype_id IN ( select slotplan_pricetype_id from sales__slotitem_hour where slotplan_id=? ) ", articleId, a.getSlotplanId());
            for (BaseStringMap bsm : pts) {
                ArticleSlotplanPrice asp = new ArticleSlotplanPrice();
                asp.setBaseStringMap(bsm);
                a.getSlotplanPrices().add(asp);
            }
        }
        return a;
    }

    public void deleteArticle(Integer articleId) throws SQLException, JTBException {
        this.connection.query("delete from sales__article_article_group where article_id = ?", articleId);
        this.connection.query("delete from sales__article where article_id = ?", articleId);
    }

    public Integer saveArticle(Article art) throws IOException, SQLException, JTBException {
        Vat v = this.readVat(art.getVatId());
        if (this.salesSettings.inputPriceExclVat()) {
            if (v != null) {
                Double priceIncl = v.addVat(art.getPriceExclVat());
                art.setPriceInclVat(priceIncl);
            } else {
                art.setPriceInclVat(art.getPriceExclVat());
            }
        } else if (this.salesSettings.inputPriceInclVat()) {
            if (v != null) {
                Double priceExcl = v.subtractVat(art.getPriceInclVat());
                art.setPriceExclVat(priceExcl);
            } else {
                art.setPriceExclVat(art.getPriceInclVat());
            }
        }
        Integer id = this.connection.save("sales__article", "article_id", art);
        art.setArticleId(id);
        if (art.getArticleGroupIds().size() == 0) {
            this.connection.query("delete from sales__article_article_group where article_id = ?", id);
        } else {
            List<BaseStringMap> bsms = this.connection.queryBsmList("select * from sales__article_article_group where article_id = ?", id);
            int x = 0;
            x = 0;
            while (x < art.getArticleGroupIds().size()) {
                BaseStringMap bsm;
                int agid = art.getArticleGroupIds().get(x);
                if (x < bsms.size()) {
                    bsm = bsms.get(x);
                } else {
                    bsm = new BaseStringMap();
                    bsm.setProperty("article_id", id);
                }
                bsm.setProperty("article_group_id", agid);
                if (art.getMainArticleGroupId() != null) {
                    bsm.setProperty("main_group", agid == art.getMainArticleGroupId() ? 1 : 0);
                }
                this.connection.save("sales__article_article_group", "article_article_group_id", bsm);
                ++x;
            }
            --x;
            while (x < bsms.size()) {
                this.connection.query("delete from sales__article_article_group where article_article_group_id = ?", bsms.get(x).getPropertyInt("article_article_group_id"));
                ++x;
            }
        }
        if (art.getSlotplanPrices().size() == 0) {
            this.connection.query("delete from sales__article_slotplan_price where article_id = ?", id);
        } else {
            int x = 0;
            while (x < art.getSlotplanPrices().size()) {
                ArticleSlotplanPrice asp = art.getSlotplanPrices().get(x);
                Integer cnt = (Integer)this.connection.queryValue("select count(*) from sales__article_slotplan_price where article_id = ? and slotplan_pricetype_id = ?", Integer.class, art.getArticleId(), asp.getSlotplanPricetypeId());
                if (cnt > 1) {
                    this.connection.query("delete from sales__article_slotplan_price where article_id = ? and slotplan_pricetype_id = ?", art.getArticleId(), asp.getSlotplanPricetypeId());
                }
                Integer aspId = (Integer)this.connection.queryValue("select article_slotplan_price_id from sales__article_slotplan_price where article_id = ? and slotplan_pricetype_id = ?", Integer.class, art.getArticleId(), asp.getSlotplanPricetypeId());
                BaseStringMap bsm = new BaseStringMap();
                bsm.setProperty("article_slotplan_price_id", aspId);
                bsm.setProperty("article_id", art.getArticleId());
                bsm.setProperty("slotplan_pricetype_id", asp.getSlotplanPricetypeId());
                if (this.salesSettings.inputPriceExclVat()) {
                    if (v != null) {
                        Double priceIncl = v.addVat(asp.getPriceExclVat());
                        asp.setPriceInclVat(priceIncl);
                    } else {
                        asp.setPriceInclVat(asp.getPriceExclVat());
                    }
                } else if (this.salesSettings.inputPriceInclVat()) {
                    if (v != null) {
                        Double priceExcl = v.subtractVat(asp.getPriceInclVat());
                        asp.setPriceExclVat(priceExcl);
                    } else {
                        asp.setPriceExclVat(asp.getPriceInclVat());
                    }
                }
                bsm.setProperty("price_excl_vat", asp.getPriceExclVat());
                bsm.setProperty("price_incl_vat", asp.getPriceInclVat());
                this.connection.save("sales__article_slotplan_price", "article_slotplan_price_id", bsm);
                ++x;
            }
        }
        return id;
    }

    public List<Vat> readVats() throws SQLException, JTBException {
        List l = this.queryToList(Vat.class, "select * from sales__vat order by sort", new Object[0]);
        return l;
    }

    public Vat readVat(Integer vatId) throws SQLException, JTBException {
        Vat v = (Vat)this.queryToObject(Vat.class, "select * from sales__vat where vat_id = ?", vatId);
        return v;
    }

    public Integer saveVat(Vat v) throws IOException, SQLException {
        if (v.isDefaultSelected().booleanValue()) {
            this.connection.query("update sales__vat set default_selected = 0", new Object[0]);
        }
        Integer vatId = this.connection.save("sales__vat", "vat_id", v.getBaseStringMap());
        return vatId;
    }

    public void updateVatSort(List<Integer> ids) throws SQLException {
        int x = 0;
        while (x < ids.size()) {
            this.connection.query("update sales__vat set sort = ? where vat_id = ?", x, ids.get(x));
            ++x;
        }
    }

    public Integer vatUseCount(Integer vatId) throws SQLException {
        Integer i = (Integer)this.connection.queryValue("select count(*) from sales__article where vat_id = ?", Integer.class, vatId);
        return i;
    }

    public void deleteVat(Integer vatId) throws InvalidStateException, SQLException {
        if (this.vatUseCount(vatId) != 0) {
            throw new InvalidStateException("Vat still in use");
        }
        this.connection.query("delete from sales__vat where vat_id = ?", vatId);
    }

    public List<ArticleGroup> readArticleGroups() throws SQLException, JTBException {
        List l = this.queryToList(ArticleGroup.class, "select * from sales__article_group order by sort", new Object[0]);
        return l;
    }

    public ArticleGroup readArticleGroup(Integer articleGroupId) throws SQLException, JTBException {
        ArticleGroup g = (ArticleGroup)this.queryToObject(ArticleGroup.class, "select * from sales__article_group where article_group_id = ?", articleGroupId);
        return g;
    }

    public Integer saveArticleGroup(ArticleGroup g) throws IOException, SQLException {
        Integer i = this.connection.save("sales__article_group", "article_group_id", g.getBaseStringMap());
        return i;
    }

    public void deleteArticleGroup(Integer articleGroupId) throws SQLException {
        this.connection.query("delete from sales__article_article_group where article_group_id = ?", articleGroupId);
        this.connection.query("delete from sales__article_group where article_group_id = ?", articleGroupId);
    }

    public void updateArticleGroupSort(List<Integer> ids) throws SQLException {
        int x = 0;
        while (x < ids.size()) {
            if (ids.get(x) != null) {
                this.connection.query("update sales__article_group set sort = ? where article_group_id = ?", x, ids.get(x));
            }
            ++x;
        }
    }
}

